/*-----------------------------------------------------------------------------------*/
/* theme main script
/*-----------------------------------------------------------------------------------*/
$(function () {

	// cufon replace all headings
	$('h2, h3, h4, h5, h6, #nav li a, h1:not("#title"), a.button').each(function() {
		Cufon(this, {
			hover : true,
			forceHitArea: true
		});
	});
	
	// and action buttons
	$('a.actionbutton').each(function() {
		Cufon(this, {
			hover : true,
			forceHitArea: true,
				textShadow: '#777 -1px -1px'
			});
	});

	// main menu dropdowns
	$('#nav ul').css({display: 'none'}); // submenus - hide them first
    $("#nav li:has(ul)").find("a:first").addClass('expandable').append('<span class="arrow"></span>'); // add arrows for submenus
	$("#nav li").hover(function(){
        $(this).find('ul:first').animate({opacity: 'toggle'},150);
    }, function(){
        $(this).find('ul:first').stop(true,true).hide();
    });

	// rotator (home page)
	$("#rotator").rotator({
		itemFade: 500,
		pagerFade: 0,
		itemShow: 3000,
		autoPlay : true,
		showPager : true
	});

	// portfolio filtering
	$('#filter li a').click(function(){
		var $this=$(this);
		if($this.hasClass('active'))
			return;			
		$this.addClass('active').parent('li').siblings().find('a').removeClass('active');
		var category=$this.attr('rel');
		var $el= category != '' ? $('#portfolio li.' + category) : $('#portfolio li');
		
		var show={opacity: 'show', width: 'toggle', scale: 1};
		var hide={opacity: 'hide', width: 'toggle', scale: 0.001};
		
		if ($.browser.msie) {
			show={opacity: 'show', width: 'toggle'};
			hide={opacity: 'hide', width: 'toggle'};
		}
		
		$el.animate(show,500).find('a.box').attr('rel','box');
		$('#portfolio li').not($el).animate(hide,500).find('a.box').attr('rel','');
	});

	// FAQ
    $('#faq > dl').faq({
		speed: 200,
		effect: 'slide',
		enumerate: true,
		toggle: false
    });

	// testimonials in footer
	$(".testimonials").rotator({
		itemFade: 300,
		pagerFade: 0,
		itemShow: 3000,
		autoPlay : true,
		showPager : false
	});

	// fancybox lightbox for all links with class 'box' (projects page, portfolio, etc.)
	$("a.box").fancybox({
		transitionIn :'elastic',
		transitionOut :'elastic',
		zoomSpeedIn: 300,
		zoomSpeedOut:	300,
		zoomOpacity: true,
		imageScale: true,
		overlayShow: true,
		titlePosition: 'inside'
	});

	// display latest tweets
	$("#twitter").twitter({
		username: "rvision",
		numTweets: 1,
		loaderText: "<ul><li>Loading...</li><ul>"
	});

	// wire client validation for forms and ajax handler:
	$('#contactform, #newsletterform').validate({
		messages: {
			newsletter_email: "*"
		},
		submitHandler: function(form) {
			var $form=$(form);
			// inform user that data is being sent:
			$('form .submit').val('Sending...');
			$.ajax({
				type: 'POST',
				url: $form.attr('action'),
				data: $form.serialize(),
				success: function(html){
					// display feedback div from response
					var msg=$('#feedback', $(html));
					$form
						.slideUp(300, function(){
							$form
								.html(msg)
								.slideDown(300);
						});
				}
			});
			return false;
		}
	});
});